import {metrics} from '../../utils/metrics';
import {setFamilyMemberExcluded} from '../../actions';
import {makeRequest} from './utils';

export const requestFamilyDelete = () => (dispatch) => {
    metrics.send(['Запрос на удаление семьи']);
    return makeRequest(dispatch, '/profile/family/common/delete');
};

export const requestExcludeMember = (placeId) => (dispatch) => {
    metrics.send(['Запрос на удаление участника']);
    return makeRequest(dispatch, '/profile/family/member/exclude', {placeId}).done(() => {
        dispatch(setFamilyMemberExcluded(placeId));
    });
};

export const requestLeaveFamily = () => (dispatch) => makeRequest(dispatch, '/profile/family/member/leave');
