import {setFamilyOffer, setFamilyOfferLoading} from '../../actions';
import {makeRequest} from './utils';

export const fetchFamilyOffer = () => (dispatch, getState) => {
    const {settings: {language} = {}, family: {familyId, familyOffer} = {}} = getState();

    dispatch(setFamilyOfferLoading(true));
    if (!familyOffer) {
        dispatch(setFamilyOffer({text: i18n('Plus.subscribe'), subText: '', familyId: ''}));
    }
    return makeRequest(dispatch, '/profile/family/offer/state', {language})
        .done(({text, subText}) => text && dispatch(setFamilyOffer({text, subText, familyId})))
        .always(() => dispatch(setFamilyOfferLoading(false)));
};
