import {makeRequest} from './utils';

export const postUnbindFamilyCard = () => (dispatch) => makeRequest(dispatch, '/profile/family/pay/unbind');

export const bindCard = ({cardId: _cardId, pmId}, retpath = '', origin = '') => (dispatch, getState) => {
    const {billing: {cards = []} = {}} = getState();
    const cardId = _cardId || cards.find((card) => card.id === pmId).cardId;

    return makeRequest(dispatch, '/profile/family/pay/bind', {cardId, retpath, origin});
};

export const postUsersLimits = () => (dispatch, getState) => {
    const {family: {payLimitsForm = {}} = {}} = getState();
    const data = {limits: JSON.stringify({users: payLimitsForm})};

    return makeRequest(dispatch, '/profile/family/pay/limits', data);
};

export const postFillBalance = (placeId) => (dispatch) =>
    makeRequest(dispatch, '/profile/family/pay/balance', {placeId});
