import {hasExp} from '@blocks/selectors';
import {metrics} from '../../utils/metrics';
import {setFamilySlots, setFamilyInfo, setFamilyAdminAccess, setFamilyPay, setPayLimitFormState} from '../../actions';
import {makeRequest} from './utils';
import {SESSION_STORAGE_KEYS} from '../../const';

export const fetchFamily = () => (dispatch, getState) => {
    const state = getState();
    const {settings: {env: {type} = {}} = {}, family: {withPayOrigin, familyId: oldFamilyId} = {}} = state;
    const isFamilyPayExp = hasExp(state, 'profile-family-pay-exp') || withPayOrigin;

    return makeRequest(dispatch, '/profile/family/common/state', {
        withKids: true
    }).done(
        ({
            members = [],
            kids = [],
            invites = [],
            hasFamilySubscription = false,
            familyId = null,
            familyCapacity,
            kiddishCapacity,
            pay = {}
        }) => {
            dispatch(
                setFamilyInfo({
                    envType: type,
                    familyId,
                    familyCapacity,
                    kiddishCapacity,
                    hasFamilySubscription
                })
            );
            const {cardInfo: {bound} = {}} = pay;
            const isAdmin = Boolean(members.find((member) => member.isYou && member.isAdmin));

            dispatch(setFamilySlots({members, kids, invites}));
            dispatch(setFamilyAdminAccess(isAdmin || !members.length));
            if (isFamilyPayExp || bound) {
                const {usersInfo = []} = pay || {};

                dispatch(setFamilyPay(pay));
                dispatch(setPayLimitFormState(usersInfo));
            }
            const noFamilyBeforeChaas = Boolean(
                sessionStorage &&
                    sessionStorage.getItem &&
                    sessionStorage.getItem(SESSION_STORAGE_KEYS.NO_FAMILY_BEFORE_CHAAS)
            );

            if (familyId && ((!oldFamilyId && isAdmin) || noFamilyBeforeChaas)) {
                if (noFamilyBeforeChaas) {
                    sessionStorage.removeItem(SESSION_STORAGE_KEYS.NO_FAMILY_BEFORE_CHAAS);
                }
                metrics.goal('family_account_create');
            }
        }
    );
};
