import api from '@blocks/api';
import {setFamilyLoading, setFamilyError} from '../../actions';

export const makeRequest = (dispatch, method, data = {}, isFormData) => {
    dispatch(setFamilyLoading(true));
    return api
        .request(method, data, isFormData && {processData: false, contentType: false})
        .fail(({code}) => dispatch(setFamilyError(code)))
        .always(() => dispatch(setFamilyLoading(false)));
};
