import {push} from 'connected-react-router';
import {metrics} from '../utils/metrics';
import {setFamilyPage} from '../actions';
import {PAGES, KIDDISH_PAGES, ROUTES} from '../const';

const checkAndChangeHistory = (page, oldPage, dispatch, withHistory) => {
    if (page === PAGES.invite && oldPage !== PAGES.invite) {
        metrics.send(['Переход на страницу семьи с инвайтом']);
        withHistory && dispatch(push(ROUTES.invite[0]));
    }
    if (page === PAGES.kiddish && oldPage !== PAGES.kiddish) {
        metrics.send(['Переход на страницу семьи с детскими профилями']);
        withHistory && dispatch(push(ROUTES.kiddish[0]));
    }
    if (page === PAGES.main && oldPage !== PAGES.main) {
        metrics.send(['Переход на главную страницу семьи']);
        withHistory && dispatch(push(ROUTES.main[0]));
    }
};

export const setPage = (page, fullPage, isModal) => (dispatch) => {
    dispatch(setFamilyPage(isModal ? {page: fullPage, modal: page} : {page, modal: null}));
};

export const goToPage = (page, canBeModal = true, withHistory = true, forceModal = false, currentPage) => (
    dispatch,
    getState
) => {
    const {settings: {isTouch} = {}, family: {pageInfo: {page: oldPage = null} = {}, isWebview} = {}} = getState();
    const mainPage = currentPage || PAGES.main;
    const isKiddishFullPage = KIDDISH_PAGES.includes(page) || (page === PAGES.slotInfo && oldPage === PAGES.kiddish);
    const fullPage = isKiddishFullPage ? PAGES.kiddish : mainPage;

    if (!canBeModal && !page) {
        page = mainPage;
    }

    !isWebview && checkAndChangeHistory(page, oldPage, dispatch, withHistory);

    dispatch(setPage(page, fullPage, canBeModal && (!isTouch || forceModal)));
};

export const goToFullPage = ({page, modal, oldPage, withHistory, isWebview = false}) => (dispatch) => {
    !isWebview && checkAndChangeHistory(page, oldPage, dispatch, withHistory);

    dispatch(setFamilyPage({page, modal}));
};

export const goToMainPage = ({modal = null, withHistory = true} = {}) => (dispatch, getState) => {
    const state = getState();
    const {common: {isFamilyEnable} = {}, family: {pageInfo: {page: oldPage = null} = {}, isWebview} = {}} = state;
    const page = isFamilyEnable ? PAGES.main : PAGES.stub;

    dispatch(goToFullPage({page, modal, oldPage, withHistory, dispatch, isWebview}));
};

export const goToInvitePage = () => (dispatch) => dispatch(goToPage(PAGES.inviteRedesign));

export const goToLoadingPage = ({modal = null, withHistory = true} = {}) => (dispatch, getState) => {
    const {common: {isFamilyEnable} = {}, family: {pageInfo: {page: oldPage = null} = {}, isWebview} = {}} = getState();
    const page = isFamilyEnable ? PAGES.loading : PAGES.stub;

    dispatch(goToFullPage({page, modal, oldPage, withHistory, dispatch, isWebview}));
};

export const goToKiddishPage = ({modal = null, withHistory = false} = {}) => (dispatch, getState) => {
    const {family: {pageInfo: {page: oldPage = null} = {}, isWebview} = {}} = getState();

    dispatch(goToFullPage({page: PAGES.kiddish, modal, oldPage, withHistory, dispatch, isWebview}));
};
