import React from 'react';
import PropTypes from 'prop-types';
import {PAGE_SELECTOR_TYPES} from '../../../const';
import {FamilyPageSelectorProvider} from '../../context';
import {getPageComponent} from '../pages';

export const FamilyPageSelectorFull = ({page}) => {
    const PageComponent = getPageComponent(page, false);

    return (
        PageComponent && (
            <FamilyPageSelectorProvider value={{page, type: PAGE_SELECTOR_TYPES.FULL}}>
                <PageComponent />
            </FamilyPageSelectorProvider>
        )
    );
};

FamilyPageSelectorFull.propTypes = {
    page: PropTypes.string
};
