import React from 'react';
import PropTypes from 'prop-types';
import {Modal} from '@components/Modal';
import {metrics} from '../../../utils/metrics';
import {getKiddishMetricParams} from '../../../utils/getKiddishMetricParams';
import {PAGES, KIDDISH_PAGES_INFO_EDIT, KIDDISH_PAGES_INFO, PAGE_SELECTOR_TYPES} from '../../../const';
import {FamilyPageSelectorProvider} from '../../context';
import {getPageComponent} from '../pages';

const calcIsModalVisible = ({page, modal, error} = {}) => Boolean(error || modal) && page !== PAGES.error;

const MODAL_CLOSE_ANIMATION_TIME = 200;

export class FamilyPageSelectorModal extends React.Component {
    state = {modal: null, isModalVisible: false};
    constructor(props) {
        super(props);

        this.state = {modal: props.modal, isModalVisible: calcIsModalVisible(props)};
    }
    componentDidUpdate(prevProps) {
        const isPrevVisible = calcIsModalVisible(prevProps);
        const isNewVisible = calcIsModalVisible(this.props);

        if (isNewVisible !== isPrevVisible) {
            this.setModalVisibleState(isNewVisible);
        }
        if (prevProps.modal !== this.props.modal && Boolean(this.props.modal)) {
            this.setModalPage(this.props.modal);
        }
    }
    setModalPage = (modal) => this.setState({modal});

    setModalVisibleState = (isVisible) => {
        this.setState({isModalVisible: isVisible});
        if (!isVisible) {
            setTimeout(
                () => !calcIsModalVisible(this.props) && this.setState({modal: null}),
                MODAL_CLOSE_ANIMATION_TIME
            );
        }
    };
    closeModal = () => {
        const {page, error, removeError, setFamilyPage} = this.props;

        setFamilyPage({page, modal: null});
        if (error && removeError) {
            removeError();
        }
    };
    onCloserClick = () => {
        const {currentSlot: {isKiddish} = {}} = this.props;
        const {modal} = this.state;
        const {type} = (isKiddish ? KIDDISH_PAGES_INFO_EDIT : KIDDISH_PAGES_INFO)[modal] || {};

        if (type) {
            metrics.sendKiddish(getKiddishMetricParams(isKiddish, type, 'Крестик'));
        }

        this.closeModal();
    };
    render() {
        const {page, error} = this.props;
        const {isModalVisible, modal} = this.state;
        const PageComponent = getPageComponent(modal, Boolean(error && page !== PAGES.error));

        return (
            <Modal
                closerView='family'
                visible={isModalVisible}
                onCloserClick={!error ? this.onCloserClick : undefined}
                onClose={!error ? this.closeModal : undefined}
                dataT='family:popup'
            >
                {PageComponent && (
                    <FamilyPageSelectorProvider value={{page: modal, type: PAGE_SELECTOR_TYPES.MODAL}}>
                        <PageComponent />
                    </FamilyPageSelectorProvider>
                )}
            </Modal>
        );
    }
}

FamilyPageSelectorModal.propTypes = {
    page: PropTypes.string,
    modal: PropTypes.string,
    currentSlot: PropTypes.object,
    error: PropTypes.object,
    removeError: PropTypes.func,
    setFamilyPage: PropTypes.func
};
