import * as Pages from '../../pages';
import {PAGES} from '../../const';

const PAGE_COMPONENTS = {
    [PAGES.main]: Pages.FamilyMainPage,
    [PAGES.empty]: Pages.FamilyEmptyPage,
    [PAGES.fakeMain]: Pages.FamilyFakeMainPage,
    [PAGES.loading]: Pages.FamilyLoadingPage,
    [PAGES.stub]: Pages.FamilyStubPage,
    [PAGES.payUnbind]: Pages.FamilyPayUnbindPage,
    [PAGES.payCards]: Pages.FamilyPayCardsPage,
    [PAGES.kiddish]: Pages.FamilyKiddishPage,
    [PAGES.kiddishName]: Pages.FamilyKiddishNamePage,
    [PAGES.kiddishAvatar]: Pages.FamilyKiddishAvatarPage,
    [PAGES.kiddishFilms]: Pages.FamilyKiddishFilmsPage,
    [PAGES.kiddishMusic]: Pages.FamilyKiddishMusicPage,
    [PAGES.kiddishRating]: Pages.FamilyKiddishRatingPage,
    [PAGES.kiddishOther]: Pages.FamilyKiddishOtherPage,
    [PAGES.kiddishRemove]: Pages.FamilyKiddishRemovePage,
    [PAGES.invite]: Pages.FamilyInvitePage,
    [PAGES.inviteRedesign]: Pages.FamilyRedesignInvitePage,
    [PAGES.slotInfo]: Pages.FamilySlotInfoPage,
    [PAGES.inviteWelcome]: Pages.FamilyWelcomePage,
    [PAGES.inviteAcceptWarning]: Pages.FamilyAcceptWarningPage,
    [PAGES.inviteAccept]: Pages.FamilyAcceptInvitePage,
    [PAGES.inviteCancel]: Pages.FamilyInviteCancelPage,
    [PAGES.memberExclude]: Pages.FamilyMemberExcludePage,
    [PAGES.memberLeave]: Pages.FamilyMemberLeavePage,
    [PAGES.error]: Pages.FamilyErrorPage,
    [PAGES.payCards]: Pages.FamilyPayCardsPage,
    [PAGES.payLimits]: Pages.FamilyPayLimitsPage,
    [PAGES.payAfter3ds]: Pages.FamilyPayAfter3dsPage,
    [PAGES.inviteShare]: Pages.FamilyInviteSharePage,
    [PAGES.inviteSend]: Pages.FamilyInviteSendPage,
    [PAGES.childishControl]: Pages.FamilyChildishControlPage,
    [PAGES.childishRating]: Pages.FamilyChildishRatingPage,
    [PAGES.childishLanding]: Pages.FamilyChildishLandingPage,
    [PAGES.addCard]: Pages.FamilyAddCardPage,
    [PAGES.addPhone]: Pages.FamilyAddPhonePage
};

export const getPageComponent = (page, isForceError) => PAGE_COMPONENTS[isForceError ? PAGES.error : page] || null;
