import React from 'react';

export const FamilyPageSelectorContext = React.createContext();
export const FamilyPageSelectorProvider = FamilyPageSelectorContext.Provider;
export const FamilyPageSelectorConsumer = FamilyPageSelectorContext.Consumer;

export const withPageSelectorContext = (Component) => (props) => (
    <FamilyPageSelectorConsumer>
        {({page, type} = {}) => <Component {...props} curPage={page} curPageSelector={type} />}
    </FamilyPageSelectorConsumer>
);
