import React from 'react';
import PropTypes from 'prop-types';
import {PAGES, PAGE_SELECTOR_TYPES} from '../../../const';
import {FamilyPageSelectorProvider} from '../../context';
import {getPageComponent} from '../pages';

export const FamilyPageSelectorLazyFull = ({page, error}) => {
    const PageComponent = getPageComponent(page, Boolean(error));

    return (
        PageComponent && (
            <FamilyPageSelectorProvider value={{page, type: PAGE_SELECTOR_TYPES.FULL, lazy: true}}>
                <PageComponent />
            </FamilyPageSelectorProvider>
        )
    );
};

FamilyPageSelectorLazyFull.propTypes = {
    page: PropTypes.oneOf(Object.values(PAGES)),
    error: PropTypes.object
};
