import loadable from '@loadable/component';
import {FamilyLoadingPage} from '../../pages/FamilyLoadingPage';
import {PAGES} from '../../const';

const loadableOptions = {fallback: FamilyLoadingPage()};

const PAGE_COMPONENTS = {
    [PAGES.inviteAccept]: loadable(
        () => import(/* webpackChunkName: "invite.accept" */ '../../pages/FamilyAcceptInvitePage'),
        loadableOptions
    ),
    [PAGES.inviteAcceptWarning]: loadable(
        () => import(/* webpackChunkName: "invite.warning" */ '../../pages/FamilyAcceptWarningPage'),
        loadableOptions
    ),
    [PAGES.inviteWelcome]: loadable(
        () => import(/* webpackChunkName: "invite.welcome" */ '../../pages/FamilyWelcomePage'),
        loadableOptions
    ),
    [PAGES.inviteRedesign]: loadable(
        () => import(/* webpackChunkName: "invite.redesign" */ '../../pages/FamilyRedesignInvitePage'),
        loadableOptions
    ),
    [PAGES.inviteCancel]: loadable(
        () => import(/* webpackChunkName: "invite.cancel" */ '../../pages/FamilyInviteCancelPage'),
        loadableOptions
    ),
    [PAGES.memberExclude]: loadable(
        () => import(/* webpackChunkName: "member.exclude" */ '../../pages/FamilyMemberExcludePage'),
        loadableOptions
    ),
    [PAGES.memberLeave]: loadable(
        () => import(/* webpackChunkName: "member.leave" */ '../../pages/FamilyMemberLeavePage'),
        loadableOptions
    ),
    [PAGES.main]: loadable(() => import(/* webpackChunkName: "main" */ '../../pages/FamilyMainPage'), loadableOptions),
    [PAGES.stub]: loadable(
        () => import(/* webpackChunkName: "main.stub" */ '../../pages/FamilyStubPage'),
        loadableOptions
    ),
    [PAGES.slotInfo]: loadable(
        () => import(/* webpackChunkName: "slot.info" */ '../../pages/FamilySlotInfoPage'),
        loadableOptions
    ),
    [PAGES.payLimits]: loadable(
        () => import(/* webpackChunkName: "pay.limits" */ '../../pages/FamilyPayLimitsPage'),
        loadableOptions
    ),
    [PAGES.payLimitsMember]: loadable(
        () => import(/* webpackChunkName: "pay.limitsMember" */ '../../pages/FamilyPayLimitsMemberPage'),
        loadableOptions
    ),
    [PAGES.payCards]: loadable(
        () => import(/* webpackChunkName: "pay.cards" */ '../../pages/FamilyPayCardsPage'),
        loadableOptions
    ),
    [PAGES.payUnbind]: loadable(
        () => import(/* webpackChunkName: "pay.unbind" */ '../../pages/FamilyPayUnbindPage'),
        loadableOptions
    ),
    [PAGES.addCard]: loadable(
        () => import(/* webpackChunkName: "add.card" */ '../../pages/FamilyAddCardPage'),
        loadableOptions
    ),
    [PAGES.addPhone]: loadable(
        () => import(/* webpackChunkName: "add.card" */ '../../pages/FamilyAddPhonePage'),
        loadableOptions
    ),
    [PAGES.error]: loadable(
        () => import(/* webpackChunkName: "error" */ '../../pages/FamilyErrorPage'),
        loadableOptions
    )
};

export const getPageComponent = (page, isForceError) => PAGE_COMPONENTS[isForceError ? PAGES.error : page] || null;
