import {connect} from 'react-redux';
import {FamilyAcceptInvitePage as Page} from './FamilyAcceptInvitePage';
import {postInviteConfirm} from '../../middlewares/api/invite';
import {requestFamilyDelete} from '../../middlewares/api/member';
import {goToPage, goToMainPage} from '../../middlewares/routing';

const mapStateToProps = (state = {}) => {
    const {
        family: {
            hasFamily,
            familyId,
            isAdminAccess,
            hasMembers,
            kiddishSlots,
            inviteSlots,
            currentSlot = {},
            inviteId,
            loading,
            isInviteConfirmed,
            isWebview = false
        } = {},
        common: {retpath} = {}
    } = state;

    return {
        hasFamily,
        hasMembers,
        hasProcessingInvitations: Boolean(inviteSlots.length),
        hasKidsProfiles: Boolean(kiddishSlots.length - 1),
        isAdmin: isAdminAccess && hasFamily,
        inviter: currentSlot,
        isInviteInYourFamily: currentSlot.familyId === familyId,
        loading,
        inviteId,
        isInviteConfirmed,
        isWebview,
        retpath
    };
};

const mapDispatchToProps = {
    confirmInvite: postInviteConfirm,
    goToPage,
    goToMainPage,
    removeFamily: requestFamilyDelete
};

export const FamilyAcceptInvitePage = connect(mapStateToProps, mapDispatchToProps)(Page);
export default FamilyAcceptInvitePage;
