import React from '@plibs/react';
import PropTypes from 'prop-types';
import {FamilyActionLayout} from '@blocks/morda/new/family/layouts/FamilyActionLayout';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {WEBVIEW_STATUS_CLOSE} from '@blocks/constants';
import {PAGES, ACCEPT_INVITE_TEXTS} from '@blocks/morda/new/family/const';

export class FamilyAcceptWarningPage extends React.Component {
    onClose = () => {
        const {goToMainPage, removeError, isWebview, retpath} = this.props;

        if (isWebview) {
            return retpath
                ? redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_CLOSE)
                : (location.href = '/profile/family');
        }

        removeError();
        goToMainPage();
    };

    getTitle = () => {
        const {isAdminAccess, hasMembers} = this.props;

        if (isAdminAccess && hasMembers) {
            return ACCEPT_INVITE_TEXTS.titles.leaveConfirm;
        }

        return ACCEPT_INVITE_TEXTS.titles.leaveConfirmSimple;
    };

    getText = () => {
        const {isAdminAccess, hasKiddish, hasFamilyCardBound, hasFamilySubscription} = this.props;

        if (isAdminAccess) {
            if (hasFamilyCardBound) {
                if (hasFamilySubscription) {
                    return hasKiddish
                        ? i18n('Family.pages.leave.text.admin.card.sub.kidddish')
                        : i18n('Family.pages.leave.text.admin.card.sub');
                } else {
                    return hasKiddish
                        ? i18n('Family.pages.leave.text.admin.card.kidddish')
                        : i18n('Family.pages.leave.text.admin.card');
                }
            } else {
                if (hasFamilySubscription) {
                    return hasKiddish
                        ? i18n('Family.pages.leave.text.admin.sub.kidddish')
                        : i18n('Family.pages.leave.text.admin.sub');
                } else {
                    return hasKiddish
                        ? i18n('Family.pages.leave.text.admin.kidddish')
                        : i18n('Family.pages.leave.text.admin');
                }
            }
        }
        if (hasFamilyCardBound) {
            return hasFamilySubscription
                ? i18n('Family.pages.leave.text.member.card.sub')
                : i18n('Family.pages.leave.text.member.card');
        }

        return hasFamilySubscription
            ? i18n('Family.pages.leave.text.member.sub')
            : i18n('Family.pages.leave.text.member');
    };

    quitFamily = () => {
        this.props.quitFamily().done(() => {
            this.joinFamily();
        });
    };

    deleteFamily = () => {
        const {deleteFamily} = this.props;

        deleteFamily().done(() => {
            this.joinFamily();
        });
    };

    joinFamily = () => {
        const {inviteId, acceptInvite, isWebview, retpath, goToPage} = this.props;

        acceptInvite(inviteId).done(() => {
            if (isWebview && retpath) {
                return goToPage(PAGES.inviteWelcome);
            }

            location.href = '/profile/family/welcome';
        });
    };

    render() {
        const {isAdminAccess, loading} = this.props;

        return (
            <div>
                <FamilyActionLayout
                    hideBackButton={true}
                    decor='leave'
                    title={this.getTitle()}
                    text={this.getText()}
                    dataTPostfix='accept-invite-warning'
                    buttons={[
                        {
                            text: i18n('Family.pages.leave.buttons.leave'),
                            view: loading ? 'action' : 'default',
                            progress: loading,
                            metric: ['Предупреждение о выходе из семьи, нажатие на кнопку "Выйти"'],
                            onClick: isAdminAccess ? this.deleteFamily : this.quitFamily
                        },
                        {
                            text: i18n('Family.pages.leave.buttons.close'),
                            view: 'transparent',
                            metric: ['Предупреждение о выходе из семьи, нажатие на кнопку "Остаться"'],
                            onClick: this.onClose
                        }
                    ]}
                />
            </div>
        );
    }
}

FamilyAcceptWarningPage.propTypes = {
    isAdminAccess: PropTypes.bool,
    quitFamily: PropTypes.func,
    deleteFamily: PropTypes.func,
    goToMainPage: PropTypes.func.isRequired,
    goToPage: PropTypes.func,
    acceptInvite: PropTypes.func,
    removeError: PropTypes.func,
    inviteId: PropTypes.string,
    loading: PropTypes.bool,
    hasMembers: PropTypes.bool,
    hasFamilyCardBound: PropTypes.bool,
    hasFamilySubscription: PropTypes.bool,
    hasKiddish: PropTypes.bool,
    isWebview: PropTypes.bool,
    retpath: PropTypes.string
};
