import {connect} from 'react-redux';
import {FamilyAcceptWarningPage as Page} from './FamilyAcceptWarningPage';
import {postInviteConfirm} from '../../middlewares/api/invite';
import {requestFamilyDelete, requestLeaveFamily} from '../../middlewares/api/member';
import {goToPage, goToMainPage} from '../../middlewares/routing';
import {removeError} from '../../middlewares/actions/common';

const mapStateToProps = (state = {}) => {
    const {
        family: {
            inviteId,
            isAdminAccess,
            hasFamilySubscription,
            hasMembers,
            kiddishSlots,
            isWebview,
            loading,
            pay = {}
        } = {},
        common: {retpath} = {}
    } = state;

    return {
        inviteId,
        isAdminAccess,
        hasMembers,
        isWebview,
        retpath,
        loading,
        hasFamilySubscription,
        hasKiddish: kiddishSlots.length > 1,
        hasFamilyCardBound: Boolean(pay.cardInfo && pay.cardInfo.bound)
    };
};

const mapDispatchToProps = {
    quitFamily: requestLeaveFamily,
    deleteFamily: requestFamilyDelete,
    acceptInvite: postInviteConfirm,
    removeError,
    goToMainPage,
    goToPage
};

export const FamilyAcceptWarningPage = connect(mapStateToProps, mapDispatchToProps)(Page);
export default FamilyAcceptWarningPage;
