import React from 'react';
import PropTypes from 'prop-types';
import {PAGES} from '@blocks/morda/new/family/const';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {WEBVIEW_STATUS_SUCCESS, WEBVIEW_STATUS_ERROR} from '@blocks/constants';
import {metrics} from '@blocks/morda/new/family/utils/metrics';
import {FamilyAddCardLayout} from '@blocks/morda/new/family/layouts/FamilyAddCardLayout';
import {CardsForm} from '@blocks/morda/cards/cards_form';
import {SESSION_STORAGE_KEYS} from '../../const';

const MAX_POLL_COUNT = 5;
const POLL_TIMEOUT = 350;

export class FamilyAddCardPage extends React.Component {
    componentDidUpdate(props) {
        const {cards, isAbort, goToPage} = this.props;

        if (isAbort !== props.isAbort && isAbort) {
            goToPage(PAGES.payCards);
        }

        if (cards !== props.cards) {
            if (cards.length > props.cards.length) {
                const cardsId = cards.map((i) => i.id);
                const oldCardsId = props.cards.map((i) => i.id);
                const newCardId = cardsId.find((cardId) => !oldCardsId.includes(cardId));

                metrics.goalPay('add_card');
                this.startBindCard(newCardId);
            } else {
                setTimeout(() => this.pollCards(), POLL_TIMEOUT);
            }
        }
    }
    pollCards = () => {
        const {getCardsInfo} = this.props;

        if (!this.pollCount) {
            this.pollCount = 0;
        }
        this.pollCount++;

        if (this.pollCount > MAX_POLL_COUNT) {
            this.noChaasHandler(false);
        } else {
            getCardsInfo();
        }
    };
    startBindCard = (pmId) => {
        const {bindCard, retpath, origin, hasFamily} = this.props;

        bindCard({pmId}, retpath, origin)
            .done(({state = 'challenge', redirectUrl, retpath = ''}) => {
                const сhaasUrl = state === 'challenge' && redirectUrl;

                metrics.sendPay(['Потребовался чаас 3дс для создания семейной оплаты', сhaasUrl ? 'Да' : 'Нет']);

                if (сhaasUrl) {
                    if (sessionStorage && sessionStorage.setItem && !hasFamily) {
                        sessionStorage.setItem(SESSION_STORAGE_KEYS.NO_FAMILY_BEFORE_CHAAS, '1');
                    }

                    window.location.href = redirectUrl;
                    return;
                }
                if (retpath) {
                    return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_SUCCESS);
                }
                this.noChaasHandler(true);
            })
            .fail(({retpath = ''}) => {
                if (retpath) {
                    return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_ERROR);
                }
            });
    };
    noChaasHandler = (status3ds) => {
        const {fetchFamily, goToPage, set3dsStatus} = this.props;

        set3dsStatus(status3ds);
        fetchFamily().done(() => goToPage(PAGES.payAfter3ds));
    };
    render() {
        const {isTouch, frameUrl, hideBackButton} = this.props;

        return (
            <FamilyAddCardLayout
                smallSidePadding={isTouch}
                mediumMaxWidthOnTouch={true}
                hideBackButton={hideBackButton}
            >
                {frameUrl && <CardsForm />}
            </FamilyAddCardLayout>
        );
    }
}

FamilyAddCardPage.propTypes = {
    isTouch: PropTypes.bool,
    isAbort: PropTypes.bool,
    hasFamily: PropTypes.bool,
    hideBackButton: PropTypes.bool,
    retpath: PropTypes.string,
    origin: PropTypes.string,
    frameUrl: PropTypes.string,
    cards: PropTypes.array,
    bindCard: PropTypes.func,
    getCardsInfo: PropTypes.func,
    fetchFamily: PropTypes.func,
    goToPage: PropTypes.func,
    set3dsStatus: PropTypes.func
};
