import {connect} from 'react-redux';
import {getCardsInfo} from '@blocks/morda/cards';
import {FamilyAddCardPage as Page} from './FamilyAddCardPage';
import {set3dsStatus} from '../../middlewares/actions/pay';
import {goToPage} from '../../middlewares/routing';
import {fetchFamily} from '../../middlewares/api/state';
import {bindCard} from '../../middlewares/api/pay';

const mapStateToProps = ({
    billing: {frameUrl = '', cards = [], isAbort} = {},
    common: {retpath} = {},
    settings: {isTouch = false} = {},
    family: {hidePayCardsPageBackButton = false, isPayCardsPage = false, origin = '', hasFamily = false} = {}
} = {}) => ({
    cards,
    frameUrl,
    retpath,
    origin,
    isAbort,
    isTouch,
    hasFamily,
    hideBackButton: isPayCardsPage && hidePayCardsPageBackButton
});

const mapDispatchToProps = {bindCard, fetchFamily, goToPage, set3dsStatus, getCardsInfo};

export const FamilyAddCardPage = connect(mapStateToProps, mapDispatchToProps)(Page);
export default FamilyAddCardPage;
