import React from '@plibs/react';
import PropTypes from 'prop-types';
import {FamilyLayout} from '@blocks/morda/new/family/components/FamilyLayout';
import {AddPhonePage} from '@blocks/phones/pages/AddPhonePage';
import {metrics} from '../../utils/metrics';
import {PAGES} from '@blocks/morda/new/family/const';

export class FamilyAddPhonePage extends React.Component {
    goToCardsPage = () => this.props.goToPage(PAGES.payCards);

    phoneBindOnSuccess = () => {
        const {fetchFamily, isAdminAccess} = this.props;

        metrics.sendPay(['Добавление телефона', 'Успех']);
        fetchFamily().done(() => isAdminAccess && this.goToCardsPage());
    };

    render() {
        const {hideBackButton} = this.props;

        return (
            <FamilyLayout hideBackButton={hideBackButton}>
                <AddPhonePage
                    place='family'
                    onSuccess={this.phoneBindOnSuccess}
                    shouldTurnOnSms2fa={true}
                    contentOnly={true}
                    shouldResetOnUnmount={true}
                    forceDecoreNegativeMargin={!hideBackButton}
                />
            </FamilyLayout>
        );
    }
}

FamilyAddPhonePage.propTypes = {
    goToPage: PropTypes.func.isRequired,
    isAdminAccess: PropTypes.bool,
    fetchFamily: PropTypes.func.isRequired,
    hideBackButton: PropTypes.bool
};
