import {connect} from 'react-redux';
import {FamilyAddPhonePage as Page} from './FamilyAddPhonePage';
import {goToPage} from '../../middlewares/routing';
import {fetchFamily} from '../../middlewares/api/state';

const mapStateToProps = ({
    family: {isAdminAccess = false, isPayCardsPage = false, hidePayCardsPageBackButton = false} = {}
} = {}) => ({
    isAdminAccess,
    hideBackButton: isPayCardsPage && hidePayCardsPageBackButton
});

const mapDispatchToProps = {goToPage, fetchFamily};

export const FamilyAddPhonePage = connect(mapStateToProps, mapDispatchToProps)(Page);
export default FamilyAddPhonePage;
