import React from 'react';
import PropTypes from 'prop-types';
import {FamilyTilesListLayout} from '../../layouts/FamilyTilesListLayout';
import {PAGES} from '../../const';

export class FamilyChildishControlPage extends React.Component {
    state = {buttons: [], tilesLists: []};
    stubFunc = () => {};
    goBack = () => this.props.goToPage(PAGES.slotInfo);
    goToMainPage = () => this.props.goToMainPage();
    goToRatingPage = () => this.props.goToPage(PAGES.childishRating);
    goToDeletePage = () => this.props.goToPage(PAGES.childishDelete);
    constructor(props) {
        super(props);

        const {passportLinks = {}, isTouch = false} = props;

        this.state = {
            buttons: [
                !isTouch && {
                    text: i18n('_AUTH_.common.back'),
                    onClick: this.goBack,
                    view: 'default',
                    dataT: 'control-childish:back'
                },
                {
                    text: i18n('Frontend.close'),
                    onClick: this.goToMainPage,
                    view: 'default',
                    dataT: 'control-childish:close'
                }
            ].filter(Boolean),
            tilesLists: [
                [
                    {
                        type: 'link',
                        title: i18n('Family.pages.control-childish.tiles.personal-info.title'),
                        description: i18n('Family.pages.control-childish.tiles.personal-info.description'),
                        iconLeft: 'user',
                        iconLeftBg: true,
                        href: passportLinks.personalInfo,
                        dataT: 'control-childish:personal-info'
                    },
                    {
                        type: 'link',
                        title: i18n('Family.pages.control-childish.tiles.public.title'),
                        description: i18n('Family.pages.control-childish.tiles.public.description'),
                        iconLeft: 'camera',
                        iconLeftBg: true,
                        href: passportLinks.profilePublic,
                        dataT: 'control-childish:public'
                    },
                    {
                        type: 'block',
                        title: i18n('Family.pages.control-childish.tiles.ages.title'),
                        description: i18n('Family.pages.control-childish.tiles.ages.description'),
                        iconLeft: 'addKiddish',
                        iconLeftBg: true,
                        onClick: this.goToRatingPage,
                        dataT: 'control-childish:ages'
                    }
                ],
                [
                    {
                        type: 'link',
                        title: i18n('Family.pages.control-childish.tiles.restore.title'),
                        iconLeft: 'star',
                        iconLeftBg: true,
                        href: passportLinks.authRestore,
                        dataT: 'control-childish:restore'
                    },
                    {
                        type: 'block',
                        title: i18n('Family.pages.control-childish.tiles.delete.title'),
                        iconLeft: 'ban',
                        iconLeftBg: true,
                        onClick: this.goToDeletePage,
                        dataT: 'control-childish:delete'
                    }
                ]
            ]
        };
    }
    render() {
        const {tilesLists, buttons} = this.state;

        return (
            <FamilyTilesListLayout
                title={i18n('Family.pages.control-childish.title')}
                goBack={this.goBack}
                tilesLists={tilesLists}
                buttons={buttons}
            />
        );
    }
}

FamilyChildishControlPage.propTypes = {
    passportLinks: PropTypes.object,
    isTouch: PropTypes.bool,
    goToPage: PropTypes.func,
    goToMainPage: PropTypes.func
};
