import React from '@plibs/react';
import PropTypes from 'prop-types';
import {FamilyLayout} from '@blocks/morda/new/family/components/FamilyLayout';
import {ChildishRegLanding} from '@blocks/registration/childishRegLanding';

export class FamilyChildishLandingPage extends React.Component {
    goToRegistration = () => {
        const {registrationChildLink} = this.props;

        window.location.href = registrationChildLink;
    };

    render() {
        return (
            <FamilyLayout negativeMarginTop={true} hasBackButtonMarginOnTouch={true}>
                <ChildishRegLanding onNextButtonClick={this.goToRegistration} showTitle={true} />
            </FamilyLayout>
        );
    }
}

FamilyChildishLandingPage.propTypes = {
    registrationChildLink: PropTypes.string
};
