import React from 'react';
import PropTypes from 'prop-types';
import {FamilyInviteKiddishLayout} from '../../layouts/FamilyInviteKiddishLayout';
import {CHILDISH_SLIDERS, PAGES} from '../../const';

export class FamilyChildishRatingPage extends React.Component {
    onNextStepClick = () => {
        const {goToPage, postChildishRating, fetchFamily, currentSlot: {rating, placeId} = {}} = this.props;

        postChildishRating({rating, placeId}).done(() => {
            goToPage(PAGES.slotInfo);
            fetchFamily();
        });
    };
    render() {
        return (
            <FamilyInviteKiddishLayout
                title={i18n('Family.childish-rating.title')}
                slider={CHILDISH_SLIDERS.COMMON}
                isChildish={true}
                onNextStepClick={this.onNextStepClick}
            />
        );
    }
}

FamilyChildishRatingPage.propTypes = {
    currentSlot: PropTypes.object,
    goToPage: PropTypes.func,
    fetchFamily: PropTypes.func,
    postChildishRating: PropTypes.func
};
