import React from 'react';
import PropTypes from 'prop-types';
import {FamilyMainLayout} from '../../layouts/FamilyMainLayout';
import {CARDS} from '../../const';

const CARDS_KIDDISH = [{type: CARDS.kiddish}];
const CARDS_BASE = [{type: CARDS.create}, {type: CARDS.join}, ...CARDS_KIDDISH];
const CARDS_BASE_WITHOUT_KIDDISH = [{type: CARDS.create}, {type: CARDS.join}];

const CARDS_PAY = [{type: CARDS.plusSmall}, {type: CARDS.pay}, ...CARDS_BASE];
const CARDS_PAY_WITHOUT_KIDDISH = [{type: CARDS.plusSmall}, {type: CARDS.pay}, ...CARDS_BASE_WITHOUT_KIDDISH];
const CARDS_PAY_WITHOUT_PLUS_AND_KIDDISH = [{type: CARDS.pay}, ...CARDS_BASE_WITHOUT_KIDDISH];

export class FamilyEmptyPage extends React.Component {
    getCards = () => {
        const {hideKiddishCards, hidePlusAndKiddishCards} = this.props;

        return hidePlusAndKiddishCards
            ? CARDS_PAY_WITHOUT_PLUS_AND_KIDDISH
            : hideKiddishCards
            ? CARDS_PAY_WITHOUT_KIDDISH
            : CARDS_PAY;
    };

    render() {
        return <FamilyMainLayout cards={this.getCards()} />;
    }
}

FamilyEmptyPage.propTypes = {
    kiddishAvatars: PropTypes.array.isRequired,
    loading: PropTypes.bool,
    setCurrentSlot: PropTypes.func.isRequired,
    hidePlusAndKiddishCards: PropTypes.bool,
    hideKiddishCards: PropTypes.bool
};
