import React from 'react';
import PropTypes from 'prop-types';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {WEBVIEW_STATUS_ERROR} from '@blocks/constants';
import {FamilyActionLayout} from '../../layouts/FamilyActionLayout';
import {ERRORS, ERRORS_BUTTON_ACTIONS, PAGES, ROUTES} from '../../const';
import {metrics} from '../../utils/metrics';

export class FamilyErrorPage extends React.Component {
    componentDidMount() {
        const {error} = this.props;

        metrics.send(['Показ семейной ошибки', error]);
    }
    mapButton = ({
        text,
        view = 'action',
        action = ERRORS_BUTTON_ACTIONS.reload,
        metric,
        webviewStatus = WEBVIEW_STATUS_ERROR
    }) => {
        const {onResetClick, removeError, pushHistory, goToPage, isWebview, retpath} = this.props;
        const onClick = () => {
            if (![ERRORS_BUTTON_ACTIONS.relogin, ERRORS_BUTTON_ACTIONS.reload].includes(action)) {
                removeError();
            }

            if (isWebview && retpath) {
                return redirectToRetpathFromWebview(retpath, webviewStatus);
            }

            switch (action) {
                case ERRORS_BUTTON_ACTIONS.relogin:
                    return (window.location.href = `/auth?retpath=${window.location.href}`);
                case ERRORS_BUTTON_ACTIONS.reload:
                    return window.location.reload();
                case ERRORS_BUTTON_ACTIONS.redirectToMain:
                    return pushHistory(ROUTES.main[0]);
                case ERRORS_BUTTON_ACTIONS.reset:
                    return onResetClick();
                case ERRORS_BUTTON_ACTIONS.goToKiddishName:
                    return goToPage(PAGES.kiddishName);
            }
        };

        return {text, view, onClick, dataT: 'error', metric};
    };
    getErrorInfo = () => {
        const {error} = this.props;

        return ERRORS[error] || ERRORS.default;
    };
    render() {
        const {title, message, buttons, decor = 'bubble'} = this.getErrorInfo();

        return (
            <FamilyActionLayout
                hideBackButton={true}
                decor={decor}
                title={title}
                text={message}
                buttons={buttons.map(this.mapButton)}
                dataTPostfix={'error'}
            />
        );
    }
}

FamilyErrorPage.propTypes = {
    error: PropTypes.string,
    pushHistory: PropTypes.func,
    onResetClick: PropTypes.func,
    goToPage: PropTypes.func,
    removeError: PropTypes.func,
    isWebview: PropTypes.bool,
    retpath: PropTypes.string
};
