import React from 'react';
import PropTypes from 'prop-types';
import {FamilyMainLayout} from '../../layouts/FamilyMainLayout';
import {PAGES} from '../../const';

const fakeSlotsBase = new Array(3).fill({isEmpty: true, isFake: true});

export class FamilyFakeMainPage extends React.Component {
    onInviteClick = (slot) => {
        const {goToInvitePage, setCurrentSlot} = this.props;

        setCurrentSlot(slot);
        goToInvitePage();
    };
    onButtonClick = (slot) => {
        const {goToPage, setCurrentSlot} = this.props;

        setCurrentSlot(slot);
        goToPage(PAGES.slotInfo);
    };
    render() {
        const {fakeAdmin} = this.props;

        return (
            <FamilyMainLayout
                slots={[fakeAdmin, ...fakeSlotsBase]}
                isAdminAccess={true}
                memberOnClick={this.onButtonClick}
                memberOnInvite={this.onInviteClick}
            />
        );
    }
}

FamilyFakeMainPage.propTypes = {
    fakeAdmin: PropTypes.object,
    goToPage: PropTypes.func,
    goToInvitePage: PropTypes.func,
    setCurrentSlot: PropTypes.func
};
