import {connect} from 'react-redux';
import {FamilyFakeMainPage as Page} from './FamilyFakeMainPage';
import {goToPage, goToInvitePage} from '../../middlewares/routing';
import {setCurrentSlot} from '../../middlewares/actions/common';

const mapStateToProps = (state) => {
    const {person: {avatarId: avatar, displayName: name} = {}, plus: {enabled: hasPlus = false} = {}} = state;

    return {
        fakeAdmin: {
            name,
            avatar,
            hasPlus,
            isUser: true,
            isAdmin: true
        }
    };
};

const mapDispatchToProps = {goToPage, goToInvitePage, setCurrentSlot};

export const FamilyFakeMainPage = connect(mapStateToProps, mapDispatchToProps)(Page);
