import React from 'react';
import PropTypes from 'prop-types';
import {FamilyConfirmLayout} from '../../layouts/FamilyConfirmLayout';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {WEBVIEW_STATUS_CLOSE, WEBVIEW_STATUS_SUCCESS} from '@blocks/constants';

export class FamilyInviteCancelPage extends React.Component {
    onConfirm = () => {
        const {
            goToMainPage,
            requestCancelInvite,
            fetchFamily,
            currentSlot: {inviteId},
            loading,
            isWebview,
            retpath
        } = this.props;

        if (!loading && inviteId && requestCancelInvite) {
            requestCancelInvite(inviteId).done(() => {
                if (retpath && isWebview) {
                    return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_SUCCESS);
                }

                goToMainPage();
                fetchFamily();
            });
        }
    };
    onCancel = () => {
        const {goToMainPage, isWebview, retpath} = this.props;

        if (isWebview && retpath) {
            return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_CLOSE);
        }
        goToMainPage();
    };
    render() {
        const {hideBackButton} = this.props;

        return (
            <FamilyConfirmLayout
                title={i18n('Family.invite-cancel.title')}
                text={i18n('Family.invite-cancel.text')}
                agreeText={i18n('Family.invite-cancel.agree')}
                disagreeText={i18n('Family.invite-cancel.disagree')}
                hideBackButton={hideBackButton}
                onCancel={this.onCancel}
                onConfirm={this.onConfirm}
            />
        );
    }
}

FamilyInviteCancelPage.propTypes = {
    currentSlot: PropTypes.object,
    loading: PropTypes.bool,
    goToMainPage: PropTypes.func,
    requestCancelInvite: PropTypes.func,
    fetchFamily: PropTypes.func,
    hideBackButton: PropTypes.bool,
    isWebview: PropTypes.bool,
    retpath: PropTypes.string
};
