import {connect} from 'react-redux';
import {goToMainPage} from '../../middlewares/routing';
import {requestCancelInvite} from '../../middlewares/api/invite';
import {fetchFamily} from '../../middlewares/api/state';
import {FamilyInviteCancelPage as Page} from './FamilyInviteCancelPage';

const mapStateToProps = (state = {}) => {
    const {
        family: {hideInviteCancelBackButton = false, isInviteCancelPage = false, isWebview, currentSlot, inviteId} = {},
        common: {retpath} = {}
    } = state;

    return {
        hideBackButton: isInviteCancelPage && hideInviteCancelBackButton,
        currentSlot,
        inviteId,
        isWebview,
        retpath
    };
};

const mapDispatchToProps = {goToMainPage, requestCancelInvite, fetchFamily};

export const FamilyInviteCancelPage = connect(mapStateToProps, mapDispatchToProps)(Page);
export default FamilyInviteCancelPage;
