import React from 'react';
import PropTypes from 'prop-types';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {WEBVIEW_STATUS_SUCCESS} from '@blocks/constants';
import {FamilyInviteConfirmLayout} from '../../layouts/FamilyInviteConfirmLayout';
import {shortenLongNames} from '../../utils/shortenLongNames';

const getDescription = (isInviteConfirmed, {hasSubscription = false} = {}) =>
    isInviteConfirmed
        ? hasSubscription && i18n('Family.invite-confirm.confirmed.description.subscription')
        : i18n('Family.invite-confirm.unconfirmed.description');

export class FamilyInviteConfirmPage extends React.Component {
    onButtonClick = () => {
        const {inviteId, postInviteConfirm, loading, isWebview, retpath, isInviteConfirmed} = this.props;

        if (!loading && isInviteConfirmed && isWebview && retpath) {
            redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_SUCCESS);
        }

        if (!loading && inviteId) {
            postInviteConfirm(inviteId);
        }
    };
    render() {
        const {isInviteConfirmed, currentSlot, isWebview, retpath} = this.props;

        const isOnClick = !isInviteConfirmed || (isWebview && retpath);

        return (
            <FamilyInviteConfirmLayout
                admin={currentSlot}
                showAvatar={!isInviteConfirmed}
                text={
                    isInviteConfirmed
                        ? i18n('Family.invite-confirm.confirmed.text')
                        : i18n('Family.invite-confirm.unconfirmed.text').replace(
                              '%s',
                              currentSlot && shortenLongNames(currentSlot.name)
                          )
                }
                description={getDescription(isInviteConfirmed, currentSlot)}
                buttons={[
                    {
                        text: isInviteConfirmed
                            ? i18n('Family.invite-confirm.confirmed.button')
                            : i18n('Family.invite-confirm.unconfirmed.button'),
                        view: 'action',
                        dataT: 'confirm-invite',
                        to: !isOnClick ? '/profile/family' : undefined,
                        onClick: isOnClick ? this.onButtonClick : undefined,
                        metric: !isInviteConfirmed && ['Нажатие на кнопку "принять инвайт"']
                    }
                ]}
            />
        );
    }
}

FamilyInviteConfirmPage.propTypes = {
    currentSlot: PropTypes.object,
    isInviteConfirmed: PropTypes.bool,
    loading: PropTypes.bool,
    inviteId: PropTypes.string,
    postInviteConfirm: PropTypes.func,
    isWebview: PropTypes.func,
    retpath: PropTypes.string
};
