import React from 'react';
import PropTypes from 'prop-types';
import {FamilyInviteLayout} from '../../layouts/FamilyInviteLayout';
import {PAGES} from '../../const';

export class FamilyInvitePage extends React.Component {
    onInviteCreated = (contact) => {
        const {goToMainPage, fetchFamily, setFamilyInviteContact, hasFamily} = this.props;
        const modal = contact ? PAGES.inviteSend : PAGES.inviteShare;

        if (contact) {
            setFamilyInviteContact(contact);
        }
        if (hasFamily) {
            goToMainPage({modal});
            fetchFamily();
        } else {
            fetchFamily().done(() => goToMainPage({modal}));
        }
    };
    canPostInvite = () => {
        const {slots = [], loading} = this.props;

        return !loading && (!slots.length || slots.some((slot) => slot.isEmpty));
    };
    sendInvite = (contact) => {
        const {postInvite} = this.props;

        if (this.canPostInvite()) {
            postInvite(contact).done(() => this.onInviteCreated(contact));
        }
    };
    shareInvite = () => {
        const {postInvite} = this.props;

        if (this.canPostInvite()) {
            postInvite().done(() => this.onInviteCreated());
        }
    };

    render() {
        return (
            <FamilyInviteLayout
                title={i18n('Family.invite.title')}
                shareText={i18n('Family.invite.share.text')}
                shareButtonText={i18n('Family.invite.share.button')}
                inputLabel={i18n('Family.invite.input.label')}
                inputPlaceholderText={i18n('Family.invite-input.placeholder')}
                signText={i18n('Family.invite.sign.new')}
                onShareInviteClick={this.shareInvite}
                onSendInviteClick={this.sendInvite}
            />
        );
    }
}

FamilyInvitePage.propTypes = {
    hasFamily: PropTypes.bool,
    slots: PropTypes.array,
    loading: PropTypes.bool,
    fetchFamily: PropTypes.func,
    goToMainPage: PropTypes.func,
    postInvite: PropTypes.func,
    setFamilyInviteContact: PropTypes.func,
    setInviteId: PropTypes.func
};
