import {connect} from 'react-redux';
import {goToMainPage} from '../../middlewares/routing';
import {fetchFamily} from '../../middlewares/api/state';
import {postInvite} from '../../middlewares/api/invite';
import {setFamilyInviteContact, setInviteId} from '../../middlewares/actions/common';
import {FamilyInvitePage as Page} from './FamilyInvitePage';

const mapStateToProps = ({family: {loading, slots, hasFamily} = {}} = {}) => ({loading, slots, hasFamily});
const mapDispatchToProps = {goToMainPage, fetchFamily, postInvite, setFamilyInviteContact, setInviteId};

export const FamilyInvitePage = connect(mapStateToProps, mapDispatchToProps)(Page);
