import React from 'react';
import PropTypes from 'prop-types';
import {FamilyMessageLayout} from '../../layouts/FamilyMessageLayout';

export class FamilyInviteSendPage extends React.Component {
    state = {buttons: []};
    constructor(props) {
        super(props);

        this.state = {
            buttons: [
                {
                    text: i18n('Family.modal.invite-send.button'),
                    onClick: () => props.goToMainPage(),
                    view: 'action',
                    dataT: 'invite-send'
                }
            ]
        };
    }
    render() {
        const {inviteContact} = this.props;
        const {buttons} = this.state;

        return (
            <FamilyMessageLayout
                title={i18n('Family.modal.invite-send.title').replace('%s', inviteContact)}
                text={i18n('Family.modal.invite-send.text')}
                buttons={buttons}
            />
        );
    }
}

FamilyInviteSendPage.propTypes = {
    goToMainPage: PropTypes.func,
    inviteContact: PropTypes.string
};
