import React from 'react';
import PropTypes from 'prop-types';
import {FamilyMessageLayout} from '../../layouts/FamilyMessageLayout';
import {FamilyInviteLink} from '../../components/FamilyInviteLink';

export class FamilyInviteSharePage extends React.Component {
    state = {hideCopy: false};
    onShareClick = () => {
        const {inviteLink, goToMainPage} = this.props;

        navigator.share({url: inviteLink});

        goToMainPage();
    };
    onCopyClick = () => {
        const {inviteLink, goToMainPage} = this.props;

        try {
            navigator.clipboard.writeText(inviteLink);
        } catch (e) {
            return this.setState({hideCopy: true});
        }

        goToMainPage();
    };
    render() {
        const {hideCopy} = this.state;
        const {share, clipboard: {writeText} = {}} = navigator;
        const showShare = share && typeof share === 'function';
        const showCopy = writeText && typeof writeText === 'function' && !hideCopy;

        return (
            <FamilyMessageLayout
                title={i18n('Family.modal.invite-created.title')}
                text={i18n('Family.modal.invite-created.text')}
                buttons={[
                    showCopy && {
                        text: i18n('Family.modal.invite-created.copy'),
                        dataT: 'invite-copy',
                        onClick: this.onCopyClick,
                        view: 'action'
                    },
                    showShare && {
                        text: i18n('Family.modal.invite-created.share'),
                        dataT: 'invite-share',
                        onClick: this.onShareClick,
                        view: 'default'
                    }
                ].filter(Boolean)}
            >
                <FamilyInviteLink />
            </FamilyMessageLayout>
        );
    }
}

FamilyInviteSharePage.propTypes = {
    inviteLink: PropTypes.string,
    goToMainPage: PropTypes.func.isRequired
};
