import {connect} from 'react-redux';
import {goToMainPage} from '../../middlewares/routing';
import {FamilyInviteSharePage as Page} from './FamilyInviteSharePage';

const mapStateToProps = ({settings: {host, tld, env} = {}, family: {inviteId} = {}} = {}) => {
    const envToHost = {
        testing: `https://id-test.yandex.${tld}`,
        production: `https://id.yandex.${tld}`,
        rc: host,
        development: host
    };

    return {
        inviteLink: `${envToHost[env.type || 'production']}/profile/family/invite/${inviteId}`
    };
};

const mapDispatchToProps = {goToMainPage};

export const FamilyInviteSharePage = connect(mapStateToProps, mapDispatchToProps)(Page);
