import React from 'react';
import PropTypes from 'prop-types';
import {FamilyInviteKiddishLayout} from '../../layouts/FamilyInviteKiddishLayout';
import {KIDDISH_INPUT_FIELDS} from '../../const';

export class FamilyKiddishAvatarPage extends React.Component {
    onPrevStepClick = () => this.clearCurrentSlot(this.props.currentSlot);
    onNextStepClick = () => {
        const {currentSlot = {}} = this.props;

        this.clearCurrentSlot({...currentSlot, avatar: currentSlot.tmpAvatar});
    };
    clearCurrentSlot = (slot = {}) => {
        delete slot.tmpAvatar;
        this.props.setCurrentSlot(slot);
    };
    render() {
        const {currentSlot: {tmpAvatar} = {}} = this.props;

        return (
            <FamilyInviteKiddishLayout
                title={i18n('Family.kiddish-avatar.title')}
                inputs={[{field: KIDDISH_INPUT_FIELDS.AVATAR, value: tmpAvatar}]}
                isButtonDisabled={!tmpAvatar}
                onPrevStepClick={this.onPrevStepClick}
                onNextStepClick={this.onNextStepClick}
            />
        );
    }
}

FamilyKiddishAvatarPage.propTypes = {
    currentSlot: PropTypes.object,
    updateCurrentSlot: PropTypes.func,
    setCurrentSlot: PropTypes.func
};
