import React from 'react';
import PropTypes from 'prop-types';
import {FamilyInviteKiddishLayout} from '../../layouts/FamilyInviteKiddishLayout';

export const FamilyKiddishNamePage = ({currentSlot: {name} = {}}) => {
    const realName = (name || '').trim();

    return (
        <FamilyInviteKiddishLayout
            title={i18n('Family.kiddish-name.title')}
            showAvatarSelector={true}
            isButtonDisabled={!name || !realName || !realName.length || realName.length > 39}
            inputs={[{field: 'name', value: name, text: i18n('Family.kiddish-name.name')}]}
        />
    );
};

FamilyKiddishNamePage.propTypes = {
    currentSlot: PropTypes.object
};
