import React from 'react';
import PropTypes from 'prop-types';
import {FamilyInviteKiddishLayout} from '../../layouts/FamilyInviteKiddishLayout';

export class FamilyKiddishOtherPage extends React.Component {
    state = {isButtonDisabled: false, inputs: []};
    constructor(props) {
        super(props);

        this.state = {isButtonDisabled: false, inputs: this.getInputs()};
    }
    setButtonDisabled = (isButtonDisabled) => this.setState({isButtonDisabled});
    componentDidUpdate({currentSlot: {gender: oldGender, birthday: oldBirthday} = {}} = {}) {
        const {currentSlot: {gender, birthday} = {}} = this.props;

        if (gender !== oldGender || birthday !== oldBirthday) {
            this.calcInputs();
        }
    }
    calcInputs = () => this.setState({inputs: this.getInputs()});
    getInputs = () => {
        const {currentSlot: {gender, birthday} = {}} = this.props;

        return [
            {
                field: 'gender',
                value: gender || '',
                options: [
                    {text: i18n('Family.kiddish-other.gender.unknow'), value: ''},
                    {text: i18n('Family.kiddish-other.gender.male'), value: 'm'},
                    {text: i18n('Family.kiddish-other.gender.female'), value: 'f'}
                ],
                text: i18n('Family.kiddish-other.gender.text')
            },
            {
                field: 'birthday',
                setInProgress: this.setButtonDisabled,
                value: birthday,
                text: i18n('Family.kiddish-other.birtday.text'),
                placeholders: {
                    day: i18n('Family.kiddish-other.birtday.day'),
                    year: i18n('Family.kiddish-other.birtday.year')
                }
            }
        ];
    };
    render() {
        const {isButtonDisabled, inputs} = this.state;

        return (
            <FamilyInviteKiddishLayout
                title={i18n('Family.kiddish-other.title')}
                inputs={inputs}
                isButtonDisabled={isButtonDisabled}
            />
        );
    }
}

FamilyKiddishOtherPage.propTypes = {
    currentSlot: PropTypes.object
};
