import React from 'react';
import PropTypes from 'prop-types';
import {FamilyKiddishLayout} from '../../layouts/FamilyKiddishLayout';
import {PAGES} from '../../const';

const buttonClickBase = ({loading, setCurrentSlot, goToPage}, slot, page) => {
    if (!loading) {
        setCurrentSlot(slot);
        goToPage(page);
    }
};

export class FamilyKiddishPage extends React.Component {
    onAddKiddishClick = () => {
        const {kiddishAvatars} = this.props;
        const newSlot = {avatar: kiddishAvatars[0], isKiddishOnlyThisStep: false, isEmpty: true};

        buttonClickBase(this.props, newSlot, PAGES.kiddishName);
    };
    onKiddishClick = (event) => {
        const {kiddishSlots = []} = this.props;
        const placeId = event && event.currentTarget.dataset.id;
        const slot = kiddishSlots.find((slot) => slot.placeId === placeId) || {};

        buttonClickBase(this.props, slot, PAGES.slotInfo);
    };
    render() {
        const {kiddishSlots = []} = this.props;

        return (
            <FamilyKiddishLayout
                kiddishSlots={kiddishSlots}
                onKiddishClick={this.onKiddishClick}
                onAddKiddishClick={this.onAddKiddishClick}
            />
        );
    }
}

FamilyKiddishPage.propTypes = {
    kiddishSlots: PropTypes.array.isRequired,
    kiddishAvatars: PropTypes.array.isRequired,
    loading: PropTypes.bool,
    goToPage: PropTypes.func,
    setCurrentSlot: PropTypes.func
};
