import React from 'react';
import PropTypes from 'prop-types';
import {FamilyConfirmLayout} from '../../layouts/FamilyConfirmLayout';
import {metrics} from '../../utils/metrics';
import {shortenLongNames} from '../../utils/shortenLongNames';
import {METRIC_KIDDISH_REMOVE} from '../../const';

const sendMetric = (event) => metrics.sendKiddish([METRIC_KIDDISH_REMOVE, event]);

export class FamilyKiddishRemovePage extends React.Component {
    onConfirm = () => {
        const {
            currentSlot: {uid},
            postRemoveKiddish,
            fetchFamily,
            loading,
            goToKiddishPage
        } = this.props;

        if (!loading && postRemoveKiddish && uid) {
            sendMetric('Да');
            postRemoveKiddish(uid)
                .done(() => {
                    sendMetric('Успех');
                    goToKiddishPage();
                    fetchFamily();
                })
                .fail(() => sendMetric('Ошибка'));
        }
    };
    onCancel = () => {
        const {goToKiddishPage} = this.props;

        sendMetric('Нет');
        goToKiddishPage();
    };
    componentDidMount() {
        sendMetric('Открытие');
    }
    render() {
        const {currentSlot} = this.props;

        return (
            <FamilyConfirmLayout
                title={i18n('Family.kiddish-remove.title').replace('%1', shortenLongNames(currentSlot.name))}
                agreeText={i18n('Family.kiddish-remove.agree')}
                disagreeText={i18n('Family.kiddish-remove.disagree')}
                text={i18n('Family.kiddish-remove.text')}
                onConfirm={this.onConfirm}
                onCancel={this.onCancel}
            />
        );
    }
}

FamilyKiddishRemovePage.propTypes = {
    currentSlot: PropTypes.object,
    loading: PropTypes.bool,
    hasFamilySubscription: PropTypes.bool,
    goToMainPage: PropTypes.func,
    postRemoveKiddish: PropTypes.func,
    fetchFamily: PropTypes.func,
    goToKiddishPage: PropTypes.func
};
