import {connect} from 'react-redux';
import {FamilyKiddishRemovePage as Page} from './FamilyKiddishRemovePage';
import {goToMainPage, goToKiddishPage} from '../../middlewares/routing';
import {fetchFamily} from '../../middlewares/api/state';
import {postRemoveKiddish} from '../../middlewares/api/kiddish';

const mapStateToProps = (state) => {
    const {family: {currentSlot, loading, hasFamilySubscription} = {}} = state;

    return {
        currentSlot,
        loading,
        hasFamilySubscription
    };
};

const mapDispatchToProps = {goToMainPage, postRemoveKiddish, fetchFamily, goToKiddishPage};

export const FamilyKiddishRemovePage = connect(mapStateToProps, mapDispatchToProps)(Page);
