import React from 'react';
import PropTypes from 'prop-types';
import {FamilyMainLayout} from '../../layouts/FamilyMainLayout';
import {CARDS} from '../../const';

const TOP_CARDS_PAY_EXP = [{type: CARDS.plusSmall}, {type: CARDS.pay}];
const TOP_CARDS_PAY_EXP_ONLY_PLUS = [{type: CARDS.plusSmall}];
const TOP_CARDS_PAY_EXP_WITHOUT_PLUS = [{type: CARDS.pay}];
const TOP_CARDS_PAY_EXP_WITHOUT_PAY_AND_PLUS = [];
const BOTTOM_CARDS = [];

export class FamilyMainPage extends React.Component {
    getCards = () => {
        const {hidePayCard, hidePlusCard} = this.props;

        if (hidePayCard && hidePlusCard) {
            return TOP_CARDS_PAY_EXP_WITHOUT_PAY_AND_PLUS;
        }

        if (hidePayCard && !hidePlusCard) {
            return TOP_CARDS_PAY_EXP_ONLY_PLUS;
        }

        if (!hidePayCard && hidePlusCard) {
            return TOP_CARDS_PAY_EXP_WITHOUT_PLUS;
        }

        return TOP_CARDS_PAY_EXP;
    };
    render() {
        const {slots = [], kiddishSlots = [], fakeAdmin, hasFamily} = this.props;
        const realSlots = hasFamily ? slots : [fakeAdmin, {isEmpty: true, isFake: true}];

        return (
            <FamilyMainLayout
                slots={realSlots}
                kiddishSlots={kiddishSlots}
                cards={this.getCards()}
                bottomCards={BOTTOM_CARDS}
            />
        );
    }
}

FamilyMainPage.propTypes = {
    slots: PropTypes.array,
    kiddishSlots: PropTypes.array.isRequired,
    fakeAdmin: PropTypes.object.isRequired,
    hidePayCard: PropTypes.bool,
    hasFamily: PropTypes.bool,
    hidePlusCard: PropTypes.bool
};
