import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import {FamilyMainPage as Page} from './FamilyMainPage';

const mapStateToProps = (state = {}) => {
    const {
        person: {avatarId: avatar, publicDisplayName: name} = {},
        dashboard: {plus: {enabled: hasPlus = false, allowed: showPlus = false} = {}} = {},
        family: {
            hasFamily = false,
            isAdminAccess = false,
            slots = [],
            kiddishSlots = [],
            pay: {cardInfo: {bound = false} = {}} = {},
            withPayOrigin
        } = {},
        am: {isAm} = {}
    } = state;

    const isFamilyPayExp = hasExp(state, 'profile-family-pay-exp') || withPayOrigin || bound;

    return {
        slots,
        kiddishSlots,
        fakeAdmin: {name, avatar, hasPlus, isUser: true, isAdmin: true, isFake: true},
        hasFamily,
        hidePayCard: (!bound && !isAdminAccess && hasFamily) || !isFamilyPayExp,
        hidePlusCard: isAm || (!isAdminAccess && hasFamily) || !showPlus
    };
};

export const FamilyMainPage = connect(mapStateToProps, null)(Page);
export default FamilyMainPage;
