import React from 'react';
import PropTypes from 'prop-types';
import {FamilyActionLayout} from '../../layouts/FamilyActionLayout';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {WEBVIEW_STATUS_SUCCESS, WEBVIEW_STATUS_CLOSE} from '@blocks/constants';

const getText = (hasCard, hasSub) =>
    hasCard
        ? hasSub
            ? i18n('Family.pages.exclude.text.card.sub')
            : i18n('Family.pages.exclude.text.card')
        : hasSub
        ? i18n('Family.pages.exclude.text.sub')
        : i18n('Family.pages.exclude.text');

export class FamilyMemberExcludePage extends React.Component {
    onConfirm = () => {
        const {
            currentSlot: {placeId},
            goToMainPage,
            requestExcludeMember,
            fetchFamily,
            loading,
            isWebview,
            retpath
        } = this.props;

        if (!loading && requestExcludeMember && placeId) {
            requestExcludeMember(placeId).done(() => {
                if (isWebview && retpath) {
                    return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_SUCCESS);
                }

                goToMainPage();
                fetchFamily();
            });
        }
    };
    onClose = () => {
        const {isWebview, retpath, goToMainPage} = this.props;

        if (isWebview && retpath) {
            return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_CLOSE);
        }

        goToMainPage();
    };
    onCancel = () => this.props.goToMainPage();
    render() {
        const {currentSlot, hasCard, hasFamilySubscription, hideBackButton} = this.props;

        return (
            <FamilyActionLayout
                decor='leave'
                title={i18n('Family.pages.exclude.title')}
                text={getText(hasCard, hasFamilySubscription).replace('%s', currentSlot.name)}
                buttons={[
                    {text: i18n('Family.pages.exclude.buttons.exclude'), view: 'default', onClick: this.onConfirm},
                    {text: i18n('Family.pages.exclude.buttons.close'), view: 'transparent', onClick: this.onClose}
                ]}
                hideBackButton={hideBackButton}
            />
        );
    }
}

FamilyMemberExcludePage.propTypes = {
    currentSlot: PropTypes.object,
    loading: PropTypes.bool,
    hasFamilySubscription: PropTypes.bool,
    hasCard: PropTypes.bool,
    goToMainPage: PropTypes.func,
    requestExcludeMember: PropTypes.func,
    fetchFamily: PropTypes.func,
    hideBackButton: PropTypes.bool,
    retpath: PropTypes.string,
    isWebview: PropTypes.bool
};
