import {connect} from 'react-redux';
import {FamilyMemberExcludePage as Page} from './FamilyMemberExcludePage';
import {goToMainPage} from '../../middlewares/routing';
import {fetchFamily} from '../../middlewares/api/state';
import {requestExcludeMember} from '../../middlewares/api/member';

const mapStateToProps = (state) => {
    const {
        family: {
            loading,
            hasFamilySubscription,
            currentSlot = {},
            pay: {cardInfo: {bound: hasCard = false} = {}} = {},
            hideMembersBackButton,
            isMemberPage,
            isWebview
        } = {},
        common: {retpath} = {}
    } = state;

    return {
        currentSlot,
        loading,
        hasFamilySubscription,
        hasCard,
        hideBackButton: hideMembersBackButton && isMemberPage,
        isWebview,
        retpath
    };
};

const mapDispatchToProps = {fetchFamily, goToMainPage, requestExcludeMember};

export const FamilyMemberExcludePage = connect(mapStateToProps, mapDispatchToProps)(Page);
export default FamilyMemberExcludePage;
