import React from 'react';
import PropTypes from 'prop-types';
import {FamilyActionLayout} from '../../layouts/FamilyActionLayout';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {WEBVIEW_STATUS_SUCCESS, WEBVIEW_STATUS_CLOSE} from '@blocks/constants';

const getPayText = (isAdmin, hasCard, hasFamilySub, hasKiddish) => {
    if (isAdmin) {
        if (hasCard) {
            if (hasFamilySub) {
                return hasKiddish
                    ? i18n('Family.pages.leave.text.admin.card.sub.kidddish')
                    : i18n('Family.pages.leave.text.admin.card.sub');
            } else {
                return hasKiddish
                    ? i18n('Family.pages.leave.text.admin.card.kidddish')
                    : i18n('Family.pages.leave.text.admin.card');
            }
        } else {
            if (hasFamilySub) {
                return hasKiddish
                    ? i18n('Family.pages.leave.text.admin.sub.kidddish')
                    : i18n('Family.pages.leave.text.admin.sub');
            } else {
                return hasKiddish
                    ? i18n('Family.pages.leave.text.admin.kidddish')
                    : i18n('Family.pages.leave.text.admin');
            }
        }
    }
    if (hasCard) {
        return hasFamilySub
            ? i18n('Family.pages.leave.text.member.card.sub')
            : i18n('Family.pages.leave.text.member.card');
    }

    return hasFamilySub ? i18n('Family.pages.leave.text.member.sub') : i18n('Family.pages.leave.text.member');
};

export class FamilyMemberLeavePage extends React.Component {
    onConfirm = () => {
        const {
            goToMainPage,
            requestFamilyDelete,
            requestLeaveFamily,
            fetchFamily,
            isAdminAccess,
            loading,
            isWebview,
            retpath
        } = this.props;
        const confirmFunc = isAdminAccess ? requestFamilyDelete : requestLeaveFamily;

        if (!loading) {
            confirmFunc().done(() => {
                if (isWebview && retpath) {
                    return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_SUCCESS);
                }

                fetchFamily().done(() => goToMainPage());
            });
        }
    };
    onClose = () => {
        const {isWebview, retpath, goToMainPage} = this.props;

        if (isWebview && retpath) {
            return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_CLOSE);
        }

        goToMainPage();
    };
    onCancel = () => this.props.goToMainPage();
    render() {
        const {hasFamilySubscription, isAdminAccess, hasKiddish, hasCard, hideBackButton} = this.props;

        return (
            <FamilyActionLayout
                decor='leave'
                title={isAdminAccess ? i18n('Family.pages.leave.title.admin') : i18n('Family.pages.leave.title.member')}
                text={getPayText(isAdminAccess, hasCard, hasFamilySubscription, hasKiddish)}
                buttons={[
                    {
                        text: isAdminAccess
                            ? i18n('Family.pages.leave.buttons.delete')
                            : i18n('Family.pages.leave.buttons.leave'),
                        view: 'default',
                        onClick: this.onConfirm
                    },
                    {text: i18n('Family.pages.leave.buttons.close'), view: 'transparent', onClick: this.onClose}
                ]}
                hideBackButton={hideBackButton}
            />
        );
    }
}

FamilyMemberLeavePage.propTypes = {
    loading: PropTypes.bool,
    hasFamilySubscription: PropTypes.bool,
    hasKiddish: PropTypes.bool,
    hasCard: PropTypes.bool,
    isAdminAccess: PropTypes.bool,
    hideBackButton: PropTypes.bool,
    isWebview: PropTypes.bool,
    retpath: PropTypes.string,
    fetchFamily: PropTypes.func,
    goToMainPage: PropTypes.func,
    requestFamilyDelete: PropTypes.func,
    requestLeaveFamily: PropTypes.func
};
