import {connect} from 'react-redux';
import {FamilyMemberLeavePage as Page} from './FamilyMemberLeavePage';
import {goToMainPage} from '../../middlewares/routing';
import {fetchFamily} from '../../middlewares/api/state';
import {requestFamilyDelete, requestLeaveFamily} from '../../middlewares/api/member';

const mapStateToProps = (state) => {
    const {
        family: {
            isAdminAccess,
            loading,
            hasFamilySubscription,
            kiddishSlots,
            pay: {cardInfo: {bound: hasCard = false} = {}} = {},
            hideMembersBackButton,
            isMemberPage,
            isWebview
        } = {},
        common: {retpath} = {}
    } = state;

    return {
        isAdminAccess,
        loading,
        hasFamilySubscription,
        hasKiddish: kiddishSlots.length > 1,
        hasCard,
        hideBackButton: hideMembersBackButton && isMemberPage,
        isWebview,
        retpath
    };
};

const mapDispatchToProps = {fetchFamily, goToMainPage, requestFamilyDelete, requestLeaveFamily};

export const FamilyMemberLeavePage = connect(mapStateToProps, mapDispatchToProps)(Page);
export default FamilyMemberLeavePage;
