import React from 'react';
import PropTypes from 'prop-types';
import {FamilyActionLayout} from '../../layouts/FamilyActionLayout';
import {metrics} from '../../utils/metrics';
import {addCurrencySymbol} from '../../utils/currency';
import {PAGES, ROUTES, SESSION_STORAGE_KEYS} from '../../const';

export class FamilyPayAfter3dsPage extends React.Component {
    componentDidMount() {
        const {is3dsSuccess = false} = this.props;

        metrics.sendPay(['Показ страницы статуса подключения семейной оплаты', is3dsSuccess ? 'Успех' : 'Неудача']);
        is3dsSuccess && metrics.goalPay('add_card_confirm');
    }
    componentWillUnmount() {
        const {is3dsSuccess = false, replaceHistory} = this.props;

        metrics.sendPay(['Закрытие страницы статуса подключения семейной оплаты', is3dsSuccess ? 'Успех' : 'Неудача']);
        replaceHistory(ROUTES.main[0]);
    }
    getTitle = () => {
        const {is3dsSuccess = false, hasOnlyAdmin = false, limit, currency, language} = this.props;

        if (is3dsSuccess) {
            return (hasOnlyAdmin
                ? i18n('Family.pages.after3ds.title.invite')
                : i18n('Family.pages.after3ds.title.limit')
            ).replace('%limit', addCurrencySymbol(limit, currency, language));
        }
        return i18n('Family.pages.after3ds.title.fail');
    };
    onRepeat = () => {
        const {bindCard, fetchFamily, hasFamily, loading, set3dsStatus, cardId3ds} = this.props;

        metrics.sendPay(['Неуспех создания семейной оплаты', 'Нажатие на повторить с этой картой']);

        if (!loading && cardId3ds) {
            bindCard({cardId: cardId3ds}).done(({state = 'challenge', redirectUrl}) => {
                if (state === 'challenge' && redirectUrl) {
                    if (sessionStorage && sessionStorage.setItem && !hasFamily) {
                        sessionStorage.setItem(SESSION_STORAGE_KEYS.NO_FAMILY_BEFORE_CHAAS, '1');
                    }

                    window.location.href = redirectUrl;
                    return;
                }
                fetchFamily().done(() => set3dsStatus(true));
            });
        }
    };
    onOtherCard = () => {
        metrics.sendPay(['Неуспех создания семейной оплаты', 'Нажатие на выбрать другую карту']);
        this.props.goToPage(PAGES.payCards);
    };
    onClose = () => {
        metrics.sendPay(['Успех создания семейной оплаты', 'Нажатие на закрыть']);
        this.props.goToMainPage();
    };
    onChangeLimits = () => {
        metrics.sendPay(['Успех создания семейной оплаты', 'Нажатие на настроить лимиты']);
        this.props.goToPage(PAGES.payLimits);
    };
    onInvite = () => {
        metrics.sendPay(['Успех создания семейной оплаты', 'Нажатие на создать инвайт']);
        this.props.goToInvitePage();
    };
    getButtons = () => {
        const {is3dsSuccess = false, hasOnlyAdmin = false, cardId3ds} = this.props;

        if (is3dsSuccess) {
            return hasOnlyAdmin
                ? [
                      {
                          text: i18n('Family.pages.after3ds.buttons.invite'),
                          view: 'action',
                          onClick: this.onInvite
                      }
                  ]
                : [
                      {
                          text: i18n('Family.pages.after3ds.buttons.ok'),
                          view: 'action',
                          onClick: this.onClose
                      },
                      {
                          text: i18n('Family.pages.after3ds.buttons.limit'),
                          view: 'transparent',
                          onClick: this.onChangeLimits
                      }
                  ];
        }

        return [
            Boolean(cardId3ds) && {
                text: i18n('Family.pages.after3ds.buttons.repeat'),
                view: 'action',
                onClick: this.onRepeat
            },
            {
                text: i18n('Family.pages.after3ds.buttons.otherCard'),
                view: 'transparent',
                onClick: this.onOtherCard
            }
        ];
    };
    render() {
        const {is3dsSuccess = false, hasOnlyAdmin = false, limit, currency, language} = this.props;

        return (
            <FamilyActionLayout
                decor='familyCard'
                supertitle={is3dsSuccess && i18n('Family.pages.after3ds.supertitle.success')}
                title={this.getTitle()}
                text={
                    is3dsSuccess &&
                    hasOnlyAdmin &&
                    i18n('Family.pages.after3ds.text.invite').replace(
                        '%limit',
                        addCurrencySymbol(limit, currency, language)
                    )
                }
                textView='grey'
                buttons={this.getButtons()}
            />
        );
    }
}

FamilyPayAfter3dsPage.propTypes = {
    is3dsSuccess: PropTypes.bool,
    hasOnlyAdmin: PropTypes.bool,
    hasFamily: PropTypes.bool,
    loading: PropTypes.bool,
    limit: PropTypes.number,
    currency: PropTypes.string,
    cardId3ds: PropTypes.string,
    language: PropTypes.string,
    bindCard: PropTypes.func,
    fetchFamily: PropTypes.func,
    set3dsStatus: PropTypes.func,
    replaceHistory: PropTypes.func,
    goToPage: PropTypes.func,
    goToMainPage: PropTypes.func,
    goToInvitePage: PropTypes.func
};
