import {connect} from 'react-redux';
import {replace} from 'connected-react-router';
import {goToInvitePage, goToPage, goToMainPage} from '../../middlewares/routing';
import {bindCard} from '../../middlewares/api/pay';
import {fetchFamily} from '../../middlewares/api/state';
import {set3dsStatus} from '../../middlewares/actions/pay';
import {CURRENCIES} from '../../const';
import {FamilyPayAfter3dsPage as Page} from './FamilyPayAfter3dsPage';

const mapStateToProps = ({
    settings: {language} = {},
    family: {
        is3dsSuccess,
        loading,
        cardId3ds,
        memberSlots = [],
        yourSlotLimitInfo: {currency = CURRENCIES.RUB, limit: {value = 0} = {}} = {}
    } = {}
}) => ({
    is3dsSuccess,
    cardId3ds,
    loading,
    limit: value,
    currency,
    hasOnlyAdmin: memberSlots.length === 1,
    language: language || 'en'
});

const mapDispatchToProps = {
    goToPage,
    goToInvitePage,
    goToMainPage,
    bindCard,
    fetchFamily,
    set3dsStatus,
    replaceHistory: replace
};

export const FamilyPayAfter3dsPage = connect(mapStateToProps, mapDispatchToProps)(Page);
