import React from 'react';
import PropTypes from 'prop-types';
import {FamilyPayCardsLayout} from '../../layouts/FamilyPayCardsLayout';
import {ROUTES} from '../../const';

export class FamilyPayCardsPage extends React.Component {
    componentWillUnmount() {
        const {replaceHistory} = this.props;

        replaceHistory(ROUTES.main[0]);
    }

    render() {
        return (
            <FamilyPayCardsLayout
                title={i18n('Family.payCardsLayout.title')}
                text={i18n('Family.payCardsLayout.text')}
                warningText={i18n('Family.payCardsLayout.warning')}
            />
        );
    }
}

FamilyPayCardsPage.propTypes = {
    replaceHistory: PropTypes.func.isRequired
};
