import React from 'react';
import PropTypes from 'prop-types';
import {FamilyActionLayout} from '../../layouts/FamilyActionLayout';
import {metrics} from '../../utils/metrics';

export class FamilyPayUnbindPage extends React.Component {
    state = {buttons: []};
    constructor(props) {
        super(props);

        this.state = {
            buttons: [
                {
                    text: i18n('Family.page.payUnbind.agree'),
                    dataT: 'payUnbind:unbind',
                    view: 'default',
                    onClick: this.onUnbind
                },
                {
                    text: i18n('Family.page.payUnbind.disagree'),
                    dataT: 'payUnbind:close',
                    view: 'transparent',
                    onClick: this.onClose
                }
            ]
        };
    }
    componentDidMount() {
        metrics.sendPay(['Страница отвязки семейной оплаты', 'Показ']);
    }
    componentWillUnmount() {
        metrics.sendPay(['Страница отвязки семейной оплаты', 'Закрытие']);
    }
    onUnbind = () => {
        const {goToMainPage, postUnbindFamilyCard, fetchFamily, setPaySettingsOpenedState, loading} = this.props;

        metrics.sendPay(['Страница отвязки семейной оплаты', 'Нажатие на кнопку отвязки']);

        if (!loading) {
            postUnbindFamilyCard().done(() => {
                setPaySettingsOpenedState(false);
                goToMainPage();
                fetchFamily();
            });
        }
    };
    onClose = () => {
        metrics.sendPay(['Страница отвязки семейной оплаты', 'Нажатие на кнопку закрыть']);

        this.props.goToMainPage();
    };
    render() {
        return (
            <FamilyActionLayout
                decor='familyCard'
                title={i18n('Family.page.payUnbind.title')}
                text={i18n('Family.page.payUnbind.text')}
                buttons={this.state.buttons}
            />
        );
    }
}

FamilyPayUnbindPage.propTypes = {
    loading: PropTypes.bool,
    goToMainPage: PropTypes.func,
    setPaySettingsOpenedState: PropTypes.func,
    postUnbindFamilyCard: PropTypes.func,
    fetchFamily: PropTypes.func
};
